/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendarySchemeMaker;

import LegendaryCardMaker.CardTextDialog;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCardType;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeMaker;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeMakerFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SchemeMakerToolbar
extends JMenuBar
implements ActionListener {
    SchemeMaker hm;
    SchemeMakerFrame hmf;
    JMenu file = new JMenu("File");
    JMenuItem exportJPG = new JMenuItem("Export to JPEG...");
    JMenuItem exportPNG = new JMenuItem("Export to PNG...");
    JMenuItem exportPrinterStudioPNG = new JMenuItem("Export to Printer Studio PNG...");
    JMenuItem close = new JMenuItem("Close");
    JMenu edit = new JMenu("Edit");
    JMenu cardTypes = new JMenu("Card Type");
    List<JCheckBoxMenuItem> cardTypeItems = new ArrayList<JCheckBoxMenuItem>();
    JMenuItem setCardName = new JMenuItem("Set Card Name...");
    JMenuItem setCardNameSize = new JMenuItem("Set Card Name Size...");
    JMenuItem setCardSubName = new JMenuItem("Set Card Sub Name...");
    JMenuItem setCardSubNameSize = new JMenuItem("Set Card Sub Name Size...");
    JMenuItem setCardText = new JMenuItem("Set Card Text...");
    JMenuItem setCardTextSize = new JMenuItem("Set Card Text Size...");
    JMenuItem setBackgroundImage = new JMenuItem("Set Background Image...");
    JMenuItem setBackgroundZoom = new JMenuItem("Set Background Zoom...");
    JMenuItem setNumberInDeck = new JMenuItem("Set Number In Deck...");
    static SchemeMakerToolbar tb = null;

    public SchemeMakerToolbar(SchemeMaker hm, SchemeMakerFrame hmf) {
        tb = this;
        this.hm = hm;
        this.hmf = hmf;
        this.exportJPG.addActionListener(this);
        this.exportPNG.addActionListener(this);
        this.file.add(this.exportPNG);
        this.exportPrinterStudioPNG.addActionListener(this);
        this.file.add(this.exportPrinterStudioPNG);
        this.file.addSeparator();
        this.close.addActionListener(this);
        this.file.add(this.close);
        this.add(this.file);
        for (SchemeCardType type : SchemeCardType.values()) {
            String s = String.valueOf(type.toString().substring(0, 1).toUpperCase()) + type.toString().substring(1).toLowerCase();
            s = s.replace("_", " ");
            JCheckBoxMenuItem m = new JCheckBoxMenuItem(s);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SchemeCardType icon;
                    String enumValue = ((JCheckBoxMenuItem)e.getSource()).getText().replace(" ", "_").toUpperCase();
                    SchemeMakerToolbar.tb.hm.card.cardType = icon = SchemeCardType.valueOf(enumValue);
                    for (JCheckBoxMenuItem item : SchemeMakerToolbar.tb.cardTypeItems) {
                        if (item.getText().replace(" ", "_").toUpperCase().equals(enumValue)) {
                            item.setSelected(true);
                            continue;
                        }
                        item.setSelected(false);
                    }
                    SchemeMakerToolbar.tb.hmf.reRenderCard();
                    SchemeMakerToolbar.tb.hm.card.changed = true;
                }
            });
            this.cardTypeItems.add(m);
            this.cardTypes.add(m);
        }
        for (JCheckBoxMenuItem item : this.cardTypeItems) {
            if (item.getText().replace(" ", "_").toUpperCase().equals(hm.card.cardType.toString())) {
                item.setSelected(true);
                continue;
            }
            item.setSelected(false);
        }
        this.edit.add(this.cardTypes);
        this.setCardName.addActionListener(this);
        this.edit.add(this.setCardName);
        this.setCardNameSize.addActionListener(this);
        this.edit.add(this.setCardNameSize);
        this.setCardSubName.addActionListener(this);
        this.edit.add(this.setCardSubName);
        this.setCardSubNameSize.addActionListener(this);
        this.edit.add(this.setCardSubNameSize);
        this.setCardText.addActionListener(this);
        this.edit.add(this.setCardText);
        this.setCardTextSize.addActionListener(this);
        this.edit.add(this.setCardTextSize);
        this.setBackgroundImage.addActionListener(this);
        this.edit.add(this.setBackgroundImage);
        this.setBackgroundZoom.addActionListener(this);
        this.edit.add(this.setBackgroundZoom);
        this.setNumberInDeck.addActionListener(this);
        this.edit.add(this.setNumberInDeck);
        this.add(this.edit);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int outcome;
        String s;
        int confirm;
        BufferedImage bi;
        int outcome2;
        FileNameExtensionFilter filter1;
        JFileChooser chooser;
        if (e.getSource().equals(this.exportJPG)) {
            chooser = new JFileChooser();
            filter1 = new FileNameExtensionFilter("JPEG file", "jpg", "jpeg");
            chooser.addChoosableFileFilter(filter1);
            chooser.setFileFilter(filter1);
            outcome2 = chooser.showSaveDialog(this);
            if (outcome2 == 0) {
                bi = this.hm.generateCard();
                try {
                    if (!chooser.getSelectedFile().getName().toLowerCase().endsWith(".jpg") && !chooser.getSelectedFile().getName().toLowerCase().endsWith(".jpeg")) {
                        chooser.setSelectedFile(new File(String.valueOf(chooser.getSelectedFile().getAbsolutePath()) + ".jpg"));
                    }
                    if (chooser.getSelectedFile().exists()) {
                        confirm = JOptionPane.showConfirmDialog(this.hmf, "Overwrite File?", "File Exists", 0);
                        if (confirm == 0) {
                            this.hm.exportToJPEG(bi, chooser.getSelectedFile());
                        }
                    } else {
                        this.hm.exportToJPEG(bi, chooser.getSelectedFile());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ex.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.exportPNG)) {
            chooser = new JFileChooser();
            filter1 = new FileNameExtensionFilter("PNG file", "png");
            chooser.addChoosableFileFilter(filter1);
            chooser.setFileFilter(filter1);
            outcome2 = chooser.showSaveDialog(this);
            if (outcome2 == 0) {
                bi = this.hm.generateCard();
                try {
                    if (!chooser.getSelectedFile().getName().toLowerCase().endsWith(".png")) {
                        chooser.setSelectedFile(new File(String.valueOf(chooser.getSelectedFile().getAbsolutePath()) + ".png"));
                    }
                    if (chooser.getSelectedFile().exists()) {
                        confirm = JOptionPane.showConfirmDialog(this.hmf, "Overwrite File?", "File Exists", 0);
                        if (confirm == 0) {
                            SchemeMaker.exportToPNG(bi, chooser.getSelectedFile());
                        }
                    } else {
                        SchemeMaker.exportToPNG(bi, chooser.getSelectedFile());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ex.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.exportPrinterStudioPNG)) {
            chooser = new JFileChooser();
            filter1 = new FileNameExtensionFilter("PNG file", "png");
            chooser.addChoosableFileFilter(filter1);
            chooser.setFileFilter(filter1);
            outcome2 = chooser.showSaveDialog(this);
            if (outcome2 == 0) {
                bi = this.hm.generateCard();
                bi = this.hm.resizeImagePS(bi);
                try {
                    if (!chooser.getSelectedFile().getName().toLowerCase().endsWith(".png")) {
                        chooser.setSelectedFile(new File(String.valueOf(chooser.getSelectedFile().getAbsolutePath()) + ".png"));
                    }
                    if (chooser.getSelectedFile().exists()) {
                        int confirm2 = JOptionPane.showConfirmDialog(this.hmf, "Overwrite File?", "File Exists", 0);
                        if (confirm2 == 0) {
                            SchemeMaker.exportToPNG(bi, chooser.getSelectedFile());
                        }
                    } else {
                        SchemeMaker.exportToPNG(bi, chooser.getSelectedFile());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ex.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.setCardText)) {
            String s2;
            CardTextDialog d = new CardTextDialog(this.hm.card.cardText);
            if (this.hm.card.cardType.doesAllowHeadings()) {
                d.addHeaderIconButton();
                d.addHeadingButton();
            }
            if ((s2 = d.showInputDialog()) == null) {
                s2 = this.hm.card.cardText;
            }
            if (s2 != null && s2.isEmpty()) {
                s2 = null;
            }
            this.hm.card.cardText = s2;
            this.hmf.reRenderCard();
            this.hm.card.changed = true;
        }
        if (e.getSource().equals(this.setCardName)) {
            s = JOptionPane.showInputDialog(this.hmf, "Enter the Card Name", this.hm.card.name);
            if (s == null) {
                s = this.hm.card.name;
            }
            if (s != null && s.isEmpty()) {
                s = null;
            }
            this.hm.card.name = s;
            this.hmf.reRenderCard();
            this.hm.card.changed = true;
        }
        if (e.getSource().equals(this.setCardSubName)) {
            s = JOptionPane.showInputDialog(this.hmf, "Enter the Card Sub Name", this.hm.card.subCategory);
            if (s == null) {
                s = this.hm.card.subCategory;
            }
            if (s != null && s.isEmpty()) {
                s = null;
            }
            this.hm.card.subCategory = s;
            this.hmf.reRenderCard();
            this.hm.card.changed = true;
        }
        if (e.getSource().equals(this.setCardTextSize)) {
            s = JOptionPane.showInputDialog(this.hmf, "Enter the Ability Text Size", this.hm.textSize);
            if (s == null) {
                s = "" + this.hm.textSize;
            }
            if (s != null && s.isEmpty()) {
                s = "" + this.hm.textSize;
            }
            try {
                this.hm.textSize = Integer.parseInt(s);
                this.hm.card.cardTextSize = Integer.parseInt(s);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
            this.hmf.reRenderCard();
            this.hm.card.changed = true;
        }
        if (e.getSource().equals(this.setCardNameSize)) {
            s = JOptionPane.showInputDialog(this.hmf, "Enter the Card Name Size", this.hm.cardNameSize);
            if (s == null) {
                s = "" + this.hm.cardNameSize;
            }
            if (s != null && s.isEmpty()) {
                s = "" + this.hm.cardNameSize;
            }
            try {
                this.hm.cardNameSize = Integer.parseInt(s);
                this.hm.card.cardNameSize = Integer.parseInt(s);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
            this.hmf.reRenderCard();
            this.hm.card.changed = true;
        }
        if (e.getSource().equals(this.setCardSubNameSize)) {
            s = JOptionPane.showInputDialog(this.hmf, "Enter the Card Sub Name Size", this.hm.subCategorySize);
            if (s == null) {
                s = "" + this.hm.subCategorySize;
            }
            if (s != null && s.isEmpty()) {
                s = "" + this.hm.subCategorySize;
            }
            try {
                this.hm.subCategorySize = Integer.parseInt(s);
                this.hm.card.subCategorySize = Integer.parseInt(s);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
            this.hmf.reRenderCard();
            this.hm.card.changed = true;
        }
        if (e.getSource().equals(this.close)) {
            this.hmf.setVisible(false);
        }
        if (e.getSource().equals(this.setBackgroundImage) && (outcome = (chooser = new JFileChooser()).showOpenDialog(this.hmf)) == 0) {
            try {
                this.hm.card.imagePath = chooser.getSelectedFile().getAbsolutePath();
                this.hm.card.imageZoom = 1.0;
                this.hm.card.imageOffsetX = 0;
                this.hm.card.imageOffsetY = 0;
                this.hmf.reRenderCard();
                this.hm.card.changed = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource().equals(this.setBackgroundZoom)) {
            s = JOptionPane.showInputDialog(this.hmf, "Enter the Background Zoom", this.hm.card.imageZoom);
            if (s == null) {
                s = "" + this.hm.card.imageZoom;
            }
            if (s != null && s.isEmpty()) {
                s = "" + this.hm.card.imageZoom;
            }
            try {
                this.hm.card.imageZoom = Double.parseDouble(s);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
            this.hmf.reRenderCard();
            this.hm.card.changed = true;
        }
        if (e.getSource().equals(this.setNumberInDeck)) {
            s = JOptionPane.showInputDialog(this.hmf, "Enter the Number in Deck", this.hm.card.numberInDeck);
            if (s == null) {
                s = "" + this.hm.card.numberInDeck;
            }
            if (s != null && s.isEmpty()) {
                s = "" + this.hm.card.numberInDeck;
            }
            try {
                this.hm.card.numberInDeck = Integer.parseInt(s);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
            this.hm.card.changed = true;
        }
    }

    public SchemeMakerToolbar getSchemeMakerToolbar() {
        return tb;
    }
}

